%% ====================================================================
%%  `ENS.cls' - a class for rapports at ENS Paris Saclay
%%  -------------------------------------------------------------------
%%  Cécile Oliver-Leblond
%%  cecile.oliver@ens-paris-saclay.fr
%% ====================================================================
\def\fileversion{0.1b}
\def\filedate{2013/03/04}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{rapportENS}[\filedate\space v\fileversion\space-
                          a class for rapports at ENS Paris Saclay]    
                          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% gestion des options
\newif\ifENS@final\ENS@finalfalse
\newif\ifENS@draft\ENS@draftfalse
\newif\ifENS@utfhuit\ENS@utfhuitfalse
\newif\ifENS@latinun\ENS@latinunfalse
\newif\ifENS@latinneuf\ENS@latinneuffalse
\newif\ifENS@applemac\ENS@applemacfalse
\newif\ifENS@macce\ENS@maccefalse
\newif\ifENS@french\ENS@frenchfalse
\newif\ifENS@english\ENS@englishfalse
\newif\ifENS@nolang\ENS@nolangtrue
\newif\ifENS@sansserif\ENS@sansseriffalse
\newif\ifENS@times\ENS@timesfalse
\newif\ifENS@utopia\ENS@utopiafalse
\newif\ifENS@kpfonts\ENS@kpfontsfalse
\newif\ifENS@lmodern\ENS@lmodernfalse
\newif\ifENS@fourier\ENS@fourierfalse
\newif\ifENS@media\ENS@mediafalse
\newif\ifENS@todo\ENS@todofalse
\newif\ifENS@tikz\ENS@tikzfalse
\newif\ifENS@biblatex\ENS@biblatexfalse
\newif\ifENS@jurabib\ENS@jurabibfalse
\newif\ifENS@watermark\ENS@watermarkfalse
\DeclareOption{final}{\ENS@finaltrue}
\DeclareOption{draft}{\ENS@drafttrue}
\DeclareOption{utf8}{\ENS@utfhuittrue}
\DeclareOption{latin1}{\ENS@latinuntrue}
\DeclareOption{latin9}{\ENS@latinneuftrue}
\DeclareOption{applemac}{\ENS@applemactrue}
\DeclareOption{macce}{\ENS@maccetrue}
\DeclareOption{french}{\ENS@frenchtrue}
\DeclareOption{english}{\ENS@englishtrue}
\DeclareOption{sansserif}{\ENS@sansseriftrue}
\DeclareOption{times}{\ENS@timestrue}
\DeclareOption{utopia}{\ENS@utopiatrue}
\DeclareOption{kpfonts}{\ENS@kpfontstrue}
\DeclareOption{lmodern}{\ENS@lmoderntrue}
\DeclareOption{fourier}{\ENS@fouriertrue}
\DeclareOption{media}{\ENS@mediatrue}
\DeclareOption{todo}{\ENS@todotrue}
\DeclareOption{tikz}{\ENS@tikztrue}
\DeclareOption{biblatex}{\ENS@biblatextrue}
\DeclareOption{jurabib}{\ENS@jurabibtrue}
\DeclareOption{watermark}{\ENS@watermarktrue}
\ProcessOptions\relax
\ifENS@french\ENS@nolangfalse\fi
\ifENS@english\ENS@nolangfalse\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% chargement classe avec options
\ifENS@final\PassOptionsToClass{final}{book}\fi
\ifENS@draft\PassOptionsToClass{draft}{book}\fi
\LoadClass[a4paper,12pt,final]{book} %classe de base
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Packages principaux
\RequirePackage{ifpdf}             % Tester si génération d'un pdf
\RequirePackage{ifthen}			%test, boucle...
%encodage fichiers
\ifENS@utfhuit\PassOptionsToPackage{utf8}{inputenx}\fi				%encodage UTF8
\ifENS@latinun\PassOptionsToPackage{latin1}{inputenx}\fi				%encodage ISO1
\ifENS@latinneuf\PassOptionsToPackage{latin9}{inputenx}\fi				%encodage ISO15
\ifENS@applemac\PassOptionsToPackage{applemac}{inputenx}\fi		%encodage applemac
\ifENS@macce\PassOptionsToPackage{macce}{inputenx}\fi			%encodage macce
\RequirePackage{inputenx}
\RequirePackage[T1]{fontenc}										%encodage de polices (rendu)
%
%typographie
\ifENS@french\PassOptionsToPackage{french}{babel}\fi
\ifENS@english\PassOptionsToPackage{english}{babel}\fi
\ifENS@nolang\else\RequirePackage{babel}\fi
%
%Police
\ifENS@times\AtEndOfClass{\RequirePackage{times}}\fi
\ifENS@utopia\AtEndOfClass{\RequirePackage{utopia}}\fi
\ifENS@lmodern\AtEndOfClass{\RequirePackage{lmodern}}\fi
\ifENS@kpfonts\AtEndOfClass{\RequirePackage{kpfonts}}\fi
\ifENS@fourier\AtEndOfClass{\RequirePackage[oldstyle]{fourier}}\fi
\ifENS@sansserif\AtEndOfClass{\renewcommand*\familydefault{\sfdefault}}\fi
%
% mise en forme
\ifpdf\PassOptionsToPackage{pdftex}{geometry}\else\PassOptionsToPackage{dvips}{geometry}\fi
\RequirePackage{geometry} 											% Régler la taille de la page
\RequirePackage{fancybox}											% Faire de jolies boîtes
\RequirePackage{xspace}												% Gestion automatique des espaces
\RequirePackage{fancyhdr}          										% Configurer headers/footers
\RequirePackage[bf]{caption}								% Captions
\RequirePackage{tocbibind}         % ToC, ToF, etc. dans la ToC
\RequirePackage[babel=true]{csquotes}							%mise en forme des citations
%
%% Minitocs en début de chapitre
\ifENS@french\PassOptionsToPackage{french}{minitoc}\fi
\ifENS@english\PassOptionsToPackage{english}{minitoc}\fi
\RequirePackage{minitoc}
%
%tableaux
\RequirePackage{array}             % Gestion des tableaux
\RequirePackage{multirow}            % permet d'ecrire du texte sur plusieurs lignes dans un tableau
\RequirePackage{longtable}           % tableau sur plusieurs pages
\RequirePackage{threeparttable}                     %environnement de tableau avec footnote
\RequirePackage{booktabs}			%nouvelles options de mise en forme des tableaux
\RequirePackage{hhline}					%lignes doubles dans tableaux
%
%figures/images/float...
\ifpdf\PassOptionsToPackage{pdftex}{graphicx}\fi
\ifENS@draft\PassOptionsToPackage{draft}{graphicx}\fi
\ifENS@final\PassOptionsToPackage{final}{graphicx}\fi
\RequirePackage{graphicx}
\ifpdf\RequirePackage{epstopdf}\fi
\graphicspath{{figures/}}
\RequirePackage{wrapfig}              % inclusion image dans du texte
\RequirePackage{subfig} 									% Inclusion de subfigures
\RequirePackage{lscape} 				% pour mettre ce que l'on souhiate au format paysage
\RequirePackage{rotating} 				% permet la rotation des float
\RequirePackage{placeins}		% gestion de la position des images
\RequirePackage{float}			%recuperation option de positionnement absolu H et + ...
%
%chargement 3D/videos...
\ifENS@media
\ifENS@draft\PassOptionsToPackage{draft}{media9}\fi
\ifENS@final\PassOptionsToPackage{final}{media9}\fi
\RequirePackage{media9}
\fi
%
% mathematique et symboles
\RequirePackage{amsmath,amssymb,bm,stmaryrd}% Étendre les fonctions maths
\RequirePackage{eurosym}										%symboles euro
\RequirePackage{mathrsfs}										%fonte calligraphique en mathématiques (\mathscr{...})
\RequirePackage{mathtools}									%compléments de amsmath
%
%couleurs (xcolor et color)
\ifpdf\RequirePackage[pdftex]{color,xcolor}\else\RequirePackage[dvips]{color,xcolor}\fi
%
%Interactivites
\ifpdf\RequirePackage[pdftex]{hyperref}\else\RequirePackage[ps2pdf]{hyperref}\fi
\hypersetup{ 			% configuration
pdfencoding=auto,
backref=true, 				% permet d'ajouter des liens dans...
pagebackref=true,		% ...les bibliographies
hyperindex=true, 		% ajoute des liens dans les index.
colorlinks=true, 			% colorise les liens
breaklinks=true, 			% permet le retour a la ligne dans les liens trop longs
urlcolor= blue, 			% couleur des hyperliens
linkcolor= blue, 			% couleur des liens internes
citecolor=blue,			% couleurs liens citations
pdfstartview=FitH,		% affichage PDF à l'ouverture (adapter a la largeur/hauteur FitH,FitV)
bookmarks=true,		% affiche des signets pour Acrobat
pdftoolbar=true,			% affichage toobar Acrobat
pdfmenubar=true,		% affichage menu Acrobat
pdffitwindow=true,		% redimensionnement document pour l'adapter au format de la page
bookmarksopen=false} 	% si les signets Acrobat sont crees les afficher completement.
%
%Elements a ajouter dans le fichier de base:
% \hypersetup{
%pdftitle={....}, %informations apparaissant dans
%pdfauthor={...}, %dans les informations du document
%pdfsubject={...}, %sous Acrobat.
%pdfkeywords={...} {...} {...}
%}
%
%bibliographie
\RequirePackage{breakcites}			%pour eviter aux citations de déborder dans les marges
\ifENS@biblatex
\ifENS@french\PassOptionsToPackage{language=french}{biblatex}\fi
\ifENS@english\PassOptionsToPackage{language=english}{biblatex}\fi
\RequirePackage[
firstinits=false,		%Affichage de l'initiale du prénom de l'auteur
useprefix=true,		%usage de la particule dans les noms à particule
citetracker=true,		%gestion globale des citations
autopunct=false,
style=alphabetic, 	%style de bibliographie
useauthor=true,
useeditor=true,
usetranslator=true,  %exploitation du champ translator
abbreviate=false,    %pas d'abréviations
block=none,				%espacement des références
sorting=nyvt,			%classement des références
sortcites=true,
hyperref=auto,			%références interactives
autocite=footnote,	%paramétrage commande \autocite
url=false,				%inscription de l'uRl dans les références (champs: url)
doi=false,				%inscription du doi dans les références
maxnames=6,				%nombre maxi de noms affichés dans les références (sinon al.)
maxitems=50,			%nombre maxi d'éléments affichés dans les références
backend=bibtex8		%choix de l'executeur bibtex
]{biblatex}
\fi
\ifENS@jurabib
\usepackage[authorformat=allreversed,
citefull=first,
titleformat=commasep,
annotatorfirstsep=comma,
bibformat=compress,
commabeforerest,lookat,%
oxford,%
pages=format,%
idem]{jurabib}
\renewcommand{\bibansep}{, }
\fi
%
%%dessins
\ifENS@tikz
\RequirePackage{tikz}
\RequirePackage{pgfplots}
\usetikzlibrary{shapes,snakes,arrows,trees,decorations,shadows,backgrounds,calc}
\fi
%
%%watermark
\ifENS@watermark
\RequirePackage{draftwatermark}
\SetWatermarkText{Brouillon}
\ifENS@french\SetWatermarkText{Brouillon}\fi
\ifENS@english\SetWatermarkText{Draft}\fi
\fi
%
%divers
\ifENS@todo
\ifENS@french\PassOptionsToPackage{french}{todonotes}\fi
\ifENS@english\PassOptionsToPackage{english}{todonotes}\fi
\RequirePackage[obeyFinal,colorinlistoftodos,shadow]{todonotes}
\fi
\RequirePackage{calc}              	% Faire des calculs
\RequirePackage{siunitx}                % ecriture des unites en systeme SI
\RequirePackage{lastpage} 		% fourni le numero de la derniere page
\RequirePackage[tikz]{bclogo}	% cadre "design"
\RequirePackage{listings} 		%ecrire du code avec mise en forme 
\RequirePackage{verbatim} 		%ecrire sans mise en forme
\RequirePackage{fancyvrb} 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%variables page de garde

\def\ENSPreNom#1{\gdef\ensPreNom{#1}}
\def\ENSType#1{\gdef\ensType{#1}}
\def\ENSUniv#1{\gdef\ensUniv{#1}}
\def\ENSGrad#1{\gdef\ensGrad{#1}}
\def\ENSDomaine#1{\gdef\ensDomaine{#1}}
\def\ENSTitre#1{\gdef\ensTitre{#1}}
\def\ENSLieuSout#1{\gdef\ensLieuSout{#1}}
\def\ENSDateSout#1{\gdef\ensDateSout{#1}}
\def\ENSJury#1{\gdef\ensJury{#1}}
\def\ENSNum#1{\gdef\ensNum{#1}}
\def\ENSLabo#1{\gdef\ensLabo{#1}}
\def\ENSLaboComp#1{\gdef\ensLaboComp{#1}}
\def\ENSLaboAdresse#1{\gdef\ensLaboAdresse{#1}}
\newcommand{\cmddef}[1]{\textnormal{\texttt{\textbf{\textcolor{red}{#1}}}}}

\ENSPreNom{\cmddef{\textbackslash ENSPreNom\{...\}}}
\ENSType{\cmddef{\textbackslash ENSType\{...\}}}
\ENSUniv{\cmddef{\textbackslash ENSUniv\{...\}}}
\ENSGrad{\cmddef{\textbackslash ENSGrad\{...\}}}
\ENSDomaine{\cmddef{\textbackslash ENSDomaine\{...\}}}
\ENSTitre{\cmddef{\textbackslash ENSTitre\{...\}}}
\ENSLieuSout{\cmddef{\textbackslash ENSLieuSout\{...\}}}
\ENSDateSout{\cmddef{\textbackslash ENSDateSout\{...\}}}
\ENSJury{\cmddef{\textbackslash ENSJury\{...\}}}
\ENSNum{\cmddef{\textbackslash ENSNum\{...\}}}
\ENSLabo{\cmddef{\textbackslash ENSLabo\{...\}}}
\ENSLaboComp{\cmddef{\textbackslash ENSLaboComp\{...\}}}
\ENSLaboAdresse{\cmddef{\textbackslash ENSLaboAdresse\{...\}}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Parametrage
%
% marges ...
\geometry{a4paper,
          twoside,
          body={15cm,22cm},
          lmargin=3cm,
          rmargin=3cm,
          footskip=1.5cm,
          top=4cm,
          headsep=1cm,
          head=15pt}
% toc et minitoc

% Réglage de la toc
\setcounter{tocdepth}{2}       % profondeur de la toc
\setcounter{secnumdepth}{3}    % profondeur de la numérotation 

% Réglage de la minitoc
\setcounter{minitocdepth}{2}
\setlength{\mtcindent}{15pt}                % indentation des minitocs
\renewcommand{\mtcfont}{\small\rm}          % fonte des minitocs
\renewcommand{\mtcSfont}{\small\bfseries}   % fonte des minitocs
\newcommand{\mtoc}{\minitoc\thispagestyle{plain}\newpage}

% Pour gérer des interférences entre minitoc et hyperref
\let\old@tableofcontents\tableofcontents
\def\tableofcontents{\old@tableofcontents\mtcaddchapter}
\let\old@listoffigures\listoffigures
\def\listoffigures{\old@listoffigures\mtcaddchapter}
\let\old@listoftables\listoftables
\def\listoftables{\old@listoftables\mtcaddchapter}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Quelques commandes 

% Pour laisser un espace vertical entre deux paragraphes
\newcommand{\Par}{\bigskip\par}

% Pour que la page paire, ajoutée afin de commencer les chapitres
% sur une page impaire, soit sans header/footer
\newcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}%
                                   \cleardoublepage}}

% Des remerciements
\newenvironment{merci}
   {%
     \clearemptydoublepage
     \thispagestyle{empty}
     \null\vfill}
   {%
     \vfill\clearemptydoublepage}

% Des paragraphes encadrés
\newenvironment{parboxed}
   {%
     \setlength{\fboxsep}{10pt}
     \begin{Sbox}%
     \begin{minipage}{\linewidth-2\fboxrule-2\fboxsep}
     \setlength{\abovedisplayskip}{0pt}
     \setlength{\belowdisplayskip}{0pt}}
   {%
     \end{minipage}%
     \end{Sbox}
     \[\fbox{\TheSbox}\]\aftergroup\ignorespaces}

% Un résumé du chapitre
\newenvironment{resumechap}[1][]
   {%
     \vspace{2cm}
     \begin{center}
     \begin{minipage}{.7\linewidth}
     \centering\itshape}
   {%
     \end{minipage}
     \end{center}
     \vspace{2cm}}

% Configuration des headers/footers 

% Titre de bas de page
\def\lmt@foottitle{}
\newcommand{\foottitle}[1]{\def\lmt@foottitle{#1}}

% Pour une page courante : avec header et footer
\fancyhf{}
\fancyfoot[C]{\small\itshape\lmt@foottitle}
\fancyhead[RO,LE]{\small\bfseries\thepage}
\fancyhead[LO]{\nouppercase{\small\bfseries\rightmark}}
\fancyhead[RE]{\nouppercase{\small\bfseries\leftmark}}
\renewcommand{\footrulewidth}{.0pt}
\renewcommand{\headrulewidth}{.5pt}

% Pour une page de début de chapitre (ie de style plain) :
% avec seulement footer
\fancypagestyle{plain}{
\fancyhf{}
\fancyfoot[C]{\small\itshape\lmt@foottitle}
\renewcommand{\footrulewidth}{.0pt}
\renewcommand{\headrulewidth}{.0pt}}

\pagestyle{fancy}

\renewcommand{\chaptermark}[1]{\markboth{#1}{}}
\renewcommand{\sectionmark}[1]{\markright{#1}}

%  Configuration des chapitres 

% Numérotation moins chargée
\renewcommand{\thesection}{\@arabic\c@section}

% Style de chapitre, esthétique pompée dans thesetb.cls
\newfont{\chapfonte}{cmr10 scaled 9000}
\def\haut{20mm}
\def\decal{1.75ex}
\newlength{\lgnamechap}
\newlength{\lgnumchap}
\newlength{\lgall}    

% Redéfinition de \chapter
\def\@makechapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedleft \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
        \huge\bfseries \@chapapp\space \thechapter
        \par\nobreak
        \vskip 20\p@
      \fi
    \fi
    \interlinepenalty\@M
    \Huge \bfseries #1\par\nobreak
    \vskip 40\p@
  }}

% Redéfinition de \chapter*
\def\@makeschapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedleft
    \normalfont
    \interlinepenalty\@M
    \Huge \bfseries  #1\par\nobreak
    \vskip 40\p@
  }\markboth{#1}{#1}}

% Chapitre sans numéro mais qui apparait dans la ToC
\newcommand{\chapterwithnonb}[1]{\toc@chapter{#1}\mtcaddchapter}

%Gestion des flottants/références 

% Noms des flottants
\newcommand{\Figure}{\textsc{Fig.}}
\newcommand{\Tableau}{\textsc{Tab.}}
\newcommand{\Algorithme}{\textsc{Alg.}}
\newcommand{\Chapitre}{\textsc{Chap.}}
