#!/bin/bash
#
# Erathostene algorithm
#
ND=${1:-120}

# set LST as numerical table
declare -a LST

# init LST w/ value 1
for i in $( seq 1 $ND)
do
	LST[$i]=1
done

# for each value of LST, set multiples to 0
# limit is ND/2 for mult by integer (first of all = 2)
LIM=`dc -e "$ND 2/p"`
for i in $( seq 2 $LIM)
do
	for j in $( seq 2 $LIM)
	do
		k=`dc -e "$i $j *p"`
		if [ $k -le $ND ];then
			LST[$k]=0
			j=`dc -e "$j $i+p"`
		else
			break
		fi
	done
	[ `dc -e "$i $i*p"` -gt $ND ]&& break
done

# print result : only values of 1
for i in $( seq 1 $ND )
do
	if [ ${LST[$i]} -eq 1 ];then
		echo -n "$i "
	fi
done
echo ""
#.

